unit mTestSudoku;
interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, mSudoku;

type
  TfrmMain = class(TForm)
    btStartTest: TButton;
    btLoesen: TButton;
    memEin: TMemo;
    btUebernehmen: TButton;
    procedure btStartTestClick(Sender: TObject);
    procedure btLoesenClick(Sender: TObject);
    procedure btUebernehmenClick(Sender: TObject);
  private
    meinSudoku : TSudoku;
    procedure FeldZeichnen;
    procedure zeileUebernehmen(nr:integer;z : string);
    procedure zifferUebernehmen(zeile, spalte:integer;ziff : string);
    procedure ZahlenAnSudoku;

  public
    edAnzeige : array[0..80] of TEdit;
  end;

var
  frmMain: TfrmMain;

implementation{$R *.dfm}

procedure TfrmMain.FeldZeichnen;
var i:integer;
begin

 for i := 0 to 80 do begin
   edAnzeige[i] := TEdit.Create(frmMain);
   edAnzeige[i].SetBounds(20 + (i mod 9)*30, 20 + (i div 9)* 30,25,25);
   edAnzeige[i].Parent := frmMain;
   edAnzeige[i].Font.Size := 10;
   edAnzeige[i].text := '';
 end;

 with frmMain.Canvas do begin
   pen.Width := 2;
   moveto(107, 20); lineto(107, 285);
   moveto(197, 20); lineto(197, 285);
   moveto(20, 107); lineto(285, 107);
   moveto(20, 197); lineto(285, 197);
 end;
end;

procedure TfrmMain.ZahlenAnSudoku;
var i : integer; t : string;
begin
  for i := 0 to 80 do begin
    t := edAnzeige[i].Text;
    if (t>='1') and (t<='9') then meinSudoku.Zahlschreiben (i, t);
  end;
end;

procedure TfrmMain.btStartTestClick(Sender: TObject);
begin
  FeldZeichnen;
end;

procedure TfrmMain.btLoesenClick(Sender: TObject);
var i : integer;
begin
  meinSudoku := TSudoku.create;
  ZahlenAnSudoku;
  meinSudoku.Loese;
  for i := 0 to 80 do
    edAnzeige[i].Text := intToStr(meinSudoku.ZahlLesen(i));
  meinSudoku.Destroy;
end;
procedure TfrmMain.zifferUebernehmen(zeile, spalte:integer;ziff : string);
begin
  if (ziff >='1') and(ziff<='9') then edAnzeige[zeile*9+spalte].Text := ziff;
end;
procedure TfrmMain.zeileUebernehmen(nr:integer;z : string);
begin
  zifferUebernehmen (nr, 0, z[3]);
  zifferUebernehmen (nr, 1, z[4]);
  zifferUebernehmen (nr, 2, z[5]);
  zifferUebernehmen (nr, 3, z[7]);
  zifferUebernehmen (nr, 4, z[8]);
  zifferUebernehmen (nr, 5, z[9]);
  zifferUebernehmen (nr, 6, z[11]);
  zifferUebernehmen (nr, 7, z[12]);
  zifferUebernehmen (nr, 8, z[13]);
end;
procedure TfrmMain.btUebernehmenClick(Sender: TObject);
// aus dem Format des Programms SimpleSudoku
begin
  memEin.Lines.LoadFromFile('Test.ss');
  zeileUebernehmen(0, memEin.Lines[1]);
  zeileUebernehmen(1, memEin.Lines[2]);
  zeileUebernehmen(2, memEin.Lines[3]);
  zeileUebernehmen(3, memEin.Lines[5]);
  zeileUebernehmen(4, memEin.Lines[6]);
  zeileUebernehmen(5, memEin.Lines[7]);
  zeileUebernehmen(6, memEin.Lines[9]);
  zeileUebernehmen(7, memEin.Lines[10]);
  zeileUebernehmen(8, memEin.Lines[11]);
end;

end.
